package intelligence;

import intelligence.Intelligence;
import cz.cuni.pogamut.Client.Agent;

public abstract class Thought extends Thread {
    protected Agent agent;
    protected Intelligence intelligence;
    
    public static Thought create(Class c, Intelligence i) throws InstantiationException, IllegalAccessException {
        Thought t = (Thought)c.newInstance();
        t.init(i);
        return t;
    }
    
    protected Thought() {
    }
    
    protected void init(Intelligence i) {
        this.agent = i.getAgent();
        this.intelligence = i;
        this.start();
    }
    
    protected void checkValidity() {
        if (!this.valid()) {
            if (intelligence.fullLogging) {
                agent.log.info("Validity check failed");
            }
            synchronized (this.intelligence) {
                this.intelligence.removeThought(this);
                this.interrupt();
            }
        }
    }
    
    // never override this method - override think() instead! 
    @Override
    public void run() {
        if (this.intelligence.fullLogging) {
            agent.log.info("Started thinking...");
        }
        this.think();
        if (this.intelligence.fullLogging) {
            agent.log.info("Thinking finished.");
        }
        this.intelligence.removeThought(this);
    }
    
    protected abstract void think();
    // whether 
    protected abstract boolean valid();
}